/*  CLIPS Version 4.20 4/29/88 */

#include <stdio.h>

#include "clips.h"

/****************************************/
/* GLOBAL INTERNAL FUNCTION DEFINITIONS */
/****************************************/

   float                   clips_time();
   char                   *genalloc();
   int                     genexit();
   int                     genfree();
   int                     init_clips();
   int                     init_streams();

#if TRACK_MEMORY
   float                   mem_used();
   float                   mem_requests();
#endif

   float                   my_system();
   int                     sysdep_inits();
   int                     system();
   int                     (*redraw_screen)() = NULL;

/****************************************/
/* GLOBAL EXTERNAL FUNCTION DEFINITIONS */
/****************************************/
     
   extern int              add_router();
   extern int              cl_print();
   extern int              fileexit();      
   extern int              filegetc();      
   extern int              fileprint();       
   extern int              fileungetc();     
   extern int              findfile();
   
/***************************************/
/* LOCAL INTERNAL VARIABLE DEFINITIONS */
/***************************************/

   static long int         mem_amount = 0;
   static long int         mem_calls = 0;
   
/****************************************/
/* GLOBAL INTERNAL VARIABLE DEFINITIONS */
/****************************************/

   FILE                    *ld_input_fp ;

/*************************************************/
/* INIT_CLIPS: Performs initialization of CLIPS. */
/*************************************************/
#if RUN_TIME

init_clips()
  {
   init_streams();        /* Initalizes streams for I/O.       */
   sysdep_inits();        /* System dependent initializations. */   
#if DEFFACTS_CONSTRUCT
   set_up_deffacts();
#endif
  }
  
#else

init_clips()
  {
   init_streams();        /* Initalizes streams for I/O.       */
   init_symbol_table();   /* Initializes the hash table.       */
   sysdep_inits();        /* System dependent initializations. */
   sysfctns();            /* Define system functions.          */
   define_commands();     /* Define user interface functions.  */
   mathfctns();           /* Define math package functions.    */
   usrfuncs();            /* Define user functions.            */
   init_constructs();     /* Initializes constructs.           */
#if DEFFACTS_CONSTRUCT
   set_up_deffacts();
#endif
   init_gen_ptrs();       /* Initializes function pointers.    */
   init_exprn_psr();      /* Initializes expression parsers.   */
  }

/***************************************************************/
/* SET_REDRAW_FUNCTION: Redraws the screen if clipswin is main */
/*                       or does nothing.                      */
/***************************************************************/
int set_redraw_function(fun_ptr)
  int (*fun_ptr)();
  {
   redraw_screen = fun_ptr;
  }

/*****************************************************************/
/* REROUTE_STDIN: Reroutes stdin to read initially from the file */
/*                specified on the command line with -f option.  */
/*****************************************************************/
reroute_stdin(argc,argv)
int	argc;
char *argv[];
  {
   extern FILE *ld_input_fp ;
   FILE *fp;

   /* If no arguments return */
   if (argc == 1)
     { return; }

   /* If argv was not passed then forget it */
   if (argv == NULL)
     { 
      cl_print("werror","No file name passed to init function\n");
      return;
     }

   /* If not at least 2 arguments then forget it */
   if (argc != 3)
     {
      cl_print("werror","Invalid number of command line arguments\n");
      return;
     }

   /* If first argument not -f then forget it */
   if (strcmp(argv[1],"-f") != 0)
     {
      cl_print("werror","Invalid command line option\n");
      return;
     }

   /* If could not open file then forget it */
   if ((fp = fopen(argv[2],"r")) == NULL)
     {
      cl_print("werror","Could not open \"");
      cl_print("werror",argv[2]);
      cl_print("werror","\" for reading.\n");
      return;
     }
   ld_input_fp = fp ;
  }

#endif

/***************************************************/
/* GENALLOC: A generic memory allocation function. */
/***************************************************/
char *genalloc(size)
  int size;
  {
   char *mem_ptr;

#if   MAC_LSC || BLOCK_MEMORY
   extern char *request_block();   

   mem_ptr = request_block(size);
   if (mem_ptr == NULL)
     { 
      release_mem(((size * 5 > 1024) ? size * 5 : 1024));
      mem_ptr = request_block(size);
      if (mem_ptr == NULL) 
        {
         release_mem(-1);
         mem_ptr = request_block(size);
         if (mem_ptr == NULL)
           {
            cl_print("werror","ERROR: out of memory\n");
            cl_exit(1);
           }
        }
     }
#else
   extern char *malloc();

   mem_ptr = malloc(size);
   if (mem_ptr == NULL)
     { 
      release_mem(((size * 5 > 1024) ? size * 5 : 1024));
      mem_ptr = malloc(size);
      if (mem_ptr == NULL) 
        {
         release_mem(-1);
         mem_ptr = malloc(size);
         if (mem_ptr == NULL)
           {
            cl_print("werror","ERROR: out of memory\n");
            cl_exit(1);
           }
        }
     }
#endif

#if TRACK_MEMORY
   mem_amount += size;
   mem_calls++;
#endif

   return(mem_ptr);
  }

/****************************************************/
/* GENFREE: A generic memory deallocation function. */
/****************************************************/
genfree(waste,size)
  char *waste;
  int size;
  {

#if    MAC_LSC || BLOCK_MEMORY
   if (return_block(waste,size) == -1)
     { 
      cl_print("werror","Release error in genfree\n");
      return(-1);
     }
#else
   if (free(waste) == -1)
     { 
      cl_print("werror","Release error in genfree\n");
      return(-1);
     }
#endif

#if TRACK_MEMORY
   mem_amount -= size;
   mem_calls--;
#endif

   return(0);
  }

#if TRACK_MEMORY

/*******************************************/
/* MEM_USED:  Returns the amount of memory */
/*   currently allocated by CLIPS.         */
/*******************************************/
float mem_used()
  {
   return( (float) mem_amount);
  }

/***********************************************************/
/* MEM_REQUESTS:  Returns the number of outstanding memory */
/*   memory calls made through memory functions.           */
/***********************************************************/
float mem_requests()
  {
   return( (float) mem_calls);
  }

#endif

/**********************************************/
/* INIT_STREAMS:  Initializes output streams. */
/**********************************************/
init_streams()
  {
   int findfile(), fileprint(), fileexit(), filegetc(), fileungetc();
   int str_fnd(), str_getc(), str_ungetc();

   add_router("fileio",0,findfile,fileprint,filegetc,fileungetc,fileexit);
   add_router("string",0,str_fnd,NULL,str_getc,str_ungetc,NULL);
  }

/*************************************************************/
/* CLIPS_TIME: A function to return a floating point number  */
/*   which indicates the present time. Used internally by    */
/*   CLIPS for timing rule firings and debugging.            */
/*************************************************************/

#if   VMS
#include timeb
#endif

#if   IBM_MSC
#include <sys\types.h>
#include <sys\timeb.h>
#endif

#if   IBM_TBC
#include <bios.h>
#endif

#if   UNIX_7
#include <sys/types.h>
#include <sys/timeb.h>
#endif

#if   UNIX_V
#include <sys/types.h>
#include <sys/times.h>
#endif
	
float clips_time()
  {
#if   CLP_TIME

#if   VMS || IBM_MSC ||  UNIX_7
   float sec, msec, time;
   int temp;
   struct timeb time_pointer;
	
   ftime(&time_pointer);
   temp = time_pointer.time;
   temp = temp - ((temp/10000) * 10000);
   sec  = (float) temp;
   msec = (float) time_pointer.millitm;
   return(sec + (msec / 1000.0));
#endif

#if   UNIX_V
   long t_int;
   float t;
   struct tms buf;

   t_int = times(&buf);
   t = (float) t_int / 60.0;
   return(t);
#endif

#if   MAC_LSC
   unsigned long int result;
   
   result = TickCount();

   return((float) result / 60.0);
#endif

#if   IBM_TBC
   unsigned long int result;
   
   result = biostime(0,(long int) 0);

   return((float) result / 18.2);
#endif

#if IBM_LATTICE || GENERIC
   return(0.0);
#endif

#else

   return(0.0);            /* When CLIPS_TIME is not being used */

#endif                   
  }


/*****************************************************************/
/* MY_SYSTEM:  This function can be called from CLIPS.  It will  */
/*   form a command string from its arguments, and pass this     */
/*   string to the operating system.  As currently defined, this */
/*   function does nothing, however, code has been included      */
/*   which should allow this function to work under VAX VMS and  */
/*   UNIX compatible systems.                                    */
/*****************************************************************/

#if   IBM_MSC
#include <process.h>
#endif

float my_system()
  {
   char comm_buff[256];
   int buff_index = 0;
   int numa, i, j;
   VALUE arg_ptr;
   char *str_ptr, next_char;

   comm_buff[0] = EOS;
   
   if ((numa = arg_num_check("system",AT_LEAST,1)) == -1) return(0.0);

   for (i = 1 ; i <= numa; i++)
     {
      runknown(i,&arg_ptr);
      if ((get_valtype(arg_ptr) != STRING) &&
          (get_valtype(arg_ptr) != WORD))
        {
         set_execution_error(TRUE);
         exp_type_error("system",i,"word or string");
         return(0.0);
        }
      
     str_ptr = arg_ptr.val.hvalue->contents;
     j = 0;
     while ((next_char = str_ptr[j++]) != EOS)
       { 
        if (buff_index < 255)
          { comm_buff[buff_index++] = next_char; }
        else
          {
           set_execution_error(TRUE);
           cl_print("werror","Command buffer overflow in system function");
           return(0.0);
          }
       }
     comm_buff[buff_index] = EOS;
    } 

#if VMS
   vms_system(comm_buff);
#endif

#if   UNIX_7 || UNIX_V || IBM_MSC || IBM_TBC
   system(comm_buff);
#else

#if ! VMS
   cl_print("wdialog",
            "System function not fully defined for this system.\n");
#endif

#endif	

   return(1.0);
  }


#if   VMS
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

extern int LIB$SPAWN();

int vms_system(cmd)
  char *cmd;
  {
   long status, complcode;
   struct dsc$descriptor_s cmd_desc;

   cmd_desc.dsc$w_length = strlen(cmd);
   cmd_desc.dsc$a_pointer = cmd;
   cmd_desc.dsc$b_class = DSC$K_CLASS_S;
   cmd_desc.dsc$b_dtype = DSC$K_DTYPE_T;

   status = LIB$SPAWN(&cmd_desc,0,0,0,0,0,&complcode,0,0,0);
   if ((status == SS$_NORMAL) && ((complcode & STS$M_SUCCESS) != 0))
     { return 0; }
   else
     { return -1; }
  }
#endif
 
/**************************************************************/
/* The following two functions are provided to trap control-c */
/* in order to interrupt the execution of a program.          */
/**************************************************************/

#if   VMS
#include signal
#endif

#if   IBM_MSC
#include <signal.h>
#endif

sysdep_inits()
  {
#if MAC_LSC && MAC_SYSTEM
   int call_st();
#endif

#if   VMS || IBM_MSC
   int catch_ctrl_c();
#endif

#if MAC_LSC && MAC_SYSTEM
   add_exec_function("systemtask",call_st);
#endif

#if   VMS || IBM_MSC
   signal(SIGINT,catch_ctrl_c);
#endif

  }
  
#if MAC_LSC && MAC_SYSTEM
call_st()
  { SystemTask(); }
#endif

#if   VMS || IBM_MSC
catch_ctrl_c()
  {
   set_execution_error(TRUE);
   signal(SIGINT,catch_ctrl_c);
  }
#endif

/******************************************/
/* GENEXIT:  A generic exit function.     */
/*   Error codes:                         */
/*    -1 - Normal exit                    */
/*     1 - Out of memory exit             */
/*     2 - Arbitrary limit violation exit */
/*     3 - Memory release error exit      */
/*     4 - Rule parsing exit              */
/*     5 - Run time exit                  */
/*     6 - Rule maintenance exit          */
/******************************************/
genexit(num)
  int num;
  {
   exit(num);
  }
 


