/*  CLIPS Version 4.20 4/29/88 */

/****************************************************************/
/* This file is the general header file for CLIPS. It contains  */
/* the global definitions used by CLIPS, and the compiler flags */
/* you have to edit to create a version of CLIPS for a specific */
/* system.                                                      */
/*                                                              */
/* If CLIPS is being used as an embedded tool, then this file   */
/* should be included in at least the main program. Any other   */
/* files which contain functions referring to things defined in */
/* this file must also include this file.                       */
/****************************************************************/

/****************************************************************/
/* -------------------- COMPILER FLAGS ------------------------ */
/****************************************************************/

/****************************************************************/
/* Flag denoting what kind of machine CLIPS is to run on. Only  */
/* one of these flags should be turned on (set to 1) at a time. */
/****************************************************************/

#define GENERIC       1   /* Generic CLIPS (any machine)        */
#define VMS           0   /* VAX VMS                            */
#define UNIX_V        0   /* UNIX System V or 4.2bsd            */
#define UNIX_7        0   /* UNIX System III Version 7          */
#define MAC_LSC       0   /* Apple Macintosh, with Lightspeed C */
#define IBM_MSC       0   /* IBM PC, with Microsoft C (4.0)     */
#define IBM_LATTICE   0   /* IBM PC, Lattice C (3.0) not tested! */
#define IBM_TBC       0   /* IBM PC, with Turbo C (1.5 ONLY!)   */


/****************************************************************/
/* EXTENDED MATH PACKAGE FLAG: If this is on, then the extended */
/* math package functions will be available for use, (normal    */
/* default). If this flag is off, then the extended math        */ 
/* functions will not be available, and the 30K or so of space  */
/* they require will be free. Usually a concern only on PC type */
/* machines.                                                    */
/****************************************************************/

#define EX_MATH  1

/***********************************************************/
/* TIMING FLAG. If this is on, then CLIPS will call the    */ 
/* clips_time function after executing all possible rules. */ 
/* Usually used only for testing purposes.                 */
/***********************************************************/

#define CLP_TIME  1

/***************************************************************/
/* TRACK_MEMORY:  If this is on, then CLIPS will keep track of */
/*   how much memory it has allocated through genalloc and     */
/*   genfree.  This number can then be retrieved through the   */
/*   memory function.                                          */
/***************************************************************/

#define TRACK_MEMORY 1

/****************************************************************/
/* TEXT PROCESSING : Turn on this flag for support of the       */
/* hierarchical lookup system.                                  */
/****************************************************************/

#define CLP_TEXTPRO 1

/****************************************************************/
/* HELP: To implement the help facility, set the flag below and */
/* specify the path and name of the help data file your system. */
/* This options requires text processing!                       */
/****************************************************************/

#define CLP_HELP 0

#if CLP_HELP

#define HELP_DEFAULT "clips.hlp"

#endif

/****************************************************************/
/* EDITOR: If this flag is turned on, an integrated EMACS style */
/*   editor can be called directly from CLIPS                   */
/****************************************************************/

#define  CLP_EDIT  0

#if GENERIC || MAC_LSC                  
#undef CLP_EDIT                         /* Editor can't be used */
#define  CLP_EDIT  0                    /* with Generic or Mac  */
#endif

/****************************************************************/
/* RULE COMPILER: If this flag is turned on, you may compile    */
/*   CLIPS rules to C code for a run-time executable.           */
/****************************************************************/

#define  CLP_RULE_COMP  0

/****************************************************/
/* RUN_TIME:  Produces a run-time module for CLIPS. */
/****************************************************/

#define RUN_TIME 0

/****************************************************/
/* DEFFACTS_CONSTRUCT:  Determines whether deffacts */
/*   construct is included.                         */
/****************************************************/

#define DEFFACTS_CONSTRUCT 1

/*************************************************************/
/* SAVE_FACTS:  Allows inclusion of the functions save-facts */
/*   and load-facts.                                         */
/*************************************************************/

#define SAVE_FACTS 1

/******************************************************************/
/* STUDENT: Produces a version for use in teaching environments.  */
/*   Limits salience values to -2 to +2 and does not allow if and */
/*   while expressions.                                           */
/******************************************************************/

#define STUDENT 0

/*******************************************/
/* BASIC_IO: Includes printout, fprintout, */
/*   read, open, and close functions.      */
/*******************************************/

#define BASIC_IO 1

/***************************************************/
/* EXT_IO: Includes format and readline functions. */
/***************************************************/

#define EXT_IO 1

/**********************************************************************/
/* ART_CONSTRUCTS: Provides dummy ART constructs such as defrelation  */
/*   and defschema which allow ART constructs to be read from a file, */
/*   but not interpreted. Useful when converting in either direction. */
/**********************************************************************/

#define ART_CONSTRUCTS 1

/**********************************************************************/
/* BREAKPOINTS:                                                       */
/**********************************************************************/

#define BREAKPOINTS 1

/***************************************************************************/
/* MAC_SYSTEM: If using MAC_LSC and this flag is set, then SystemTask will */
/*   be called between rule firings. Allows Desk Accessories such as alarm */
/*   clock to continue working while a CLIPS program is running. Will slow */
/*   execution a little bit, but might allow network software among others */
/*   to work.                                                              */
/***************************************************************************/

#define MAC_SYSTEM 0

/************************************************************************/
/* BLOCK_MEMORY: Causes memory to be allocated in large blocks. MAC_LSC */
/*   option will also cause memory to be allocated in large blocks.     */
/*   INITBUFFERSIZE and BUFFERSIZE should both be set to less than the  */
/*   maximum size of a signed integer. On a 16-bit machine, they should */
/*   be less than 32768.                                                */
/************************************************************************/

#define BLOCK_MEMORY 1

#if MAC_LSC || BLOCK_MEMORY

#define INITBUFFERSIZE 8192   
#define BUFFERSIZE 8192      

#endif
